/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.RetrieveInternalCodeConstants;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class RetrieveInternalCodeChgsBean
extends PanelBean
implements RetrieveInternalCodeConstants,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCLRIBT";
    private static final String TRACE_MASKF = "XMCLRIBF";
    private static final String TRACE_MASKD = "XMCLRIBD";
    private String[] m_sSourceOptionsGBSelection;
    private boolean m_bRetrieveCodeChgsToHmcToggle;
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "RetrieveInternalCodeChgsBean");

    public RetrieveInternalCodeChgsBean() {
        this.setBeanName("RetrieveInternalCodeChgsPanel");
    }

    public String[] getSourceOptionsGBSelection() {
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalCodeChgsBean.getSourceOptionsGBSelection()");
        return this.m_sSourceOptionsGBSelection;
    }

    public void setSourceOptionsGBSelection(String[] selected) {
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalCodeChgsBean.setSourceOptionsGBSelection()");
        this.m_sSourceOptionsGBSelection = selected;
    }

    public boolean isRetrieveCodeChgsToHmcToggle() {
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalCodeChgsBean.isRetrieveCodeChgsToHmcToggle()");
        return this.m_bRetrieveCodeChgsToHmcToggle;
    }

    public void setRetrieveCodeChgsToHmcToggle(boolean b) {
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalCodeChgsBean.setRetrieveCodeChgsToHmcToggle()");
        this.m_bRetrieveCodeChgsToHmcToggle = b;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalCodeChgsBean.load()");
        this.setRetrieveCodeChgsToHmcToggle(false);
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeChgsBean.prepare()");
        UserTaskManager utm = this.getUserTaskManager();
        if (!CommonSystem.getCommonSystem().isClientOnServerMachine()) {
            Trace.trace(TRACE_MASKD, "[prepare()] Client and server not on same machine. Disable removable media choices.");
            utm.setEnabled("RetrieveFromDiskChoice", false);
            utm.setEnabled("RetrieveFromDVDChoice", false);
            utm.setEnabled("RetrieveToDiskChoice", false);
            utm.setEnabled("RetrieveToDVDChoice", false);
            this.setSourceOptionsGBSelection(new String[]{"RetrieveFromIBMChoice"});
        } else {
            Trace.trace(TRACE_MASKD, "[prepare()] Client and server on same machine. Do not disable removable media choices.");
            this.setSourceOptionsGBSelection(new String[]{"RetrieveFromDiskChoice"});
        }
        utm.refreshAllElements();
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeChgsBean.prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeChgsBean.panelAction()");
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKF, "[panelAction()] action command: '" + command + "'.");
        if (command.equalsIgnoreCase("CANCEL")) {
            Trace.trace(TRACE_MASKD, "[panelAction()] CANCEL action command was received.");
            this.dispose();
        } else if (command.equalsIgnoreCase("OKButton")) {
            this.getUserTaskManager().storeAllElements();
            String[] radioButtonSelection = this.getSourceOptionsGBSelection();
            Trace.trace(TRACE_MASKF, "[panelAction()] The selected radio button is: " + radioButtonSelection[0]);
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            request.setData("radioButton", radioButtonSelection[0]);
            request.setData("retrieveToHMC", this.isRetrieveCodeChgsToHmcToggle() ? "true" : "false");
            Trace.trace(TRACE_MASKD, "[panelAction()] The 'retrieve code to HMC' checkbox is: " + (this.isRetrieveCodeChgsToHmcToggle() ? "checked" : "unchecked"));
            this.postTaskletRequest(request);
        } else if (command.equalsIgnoreCase("ObjectListButton")) {
            Trace.trace(TRACE_MASKF, "[panelAction()] User clicked the 'Object List' push button.");
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKF, "[panelAction()] Ignore the unexpected action command.");
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeChgsBean.panelAction()");
    }
}

